

(defun crosstab ()
  (view (( (variables-list) (mosaic-plot) (catbox-plot) (labels-list) )
         ( (categories-list) (datasheet)       nil           nil      ))
        :rel-widths (.4 1 1 0)
        :span-down  ((1 1 1 2) (1 1 0 0))
        :span-right ((1 1 1 1) (1 2 0 0))
        :style 1); 0=seamless 1=borders 7=borders+titles
  )

(defun bivariate-view (&optional (dob $))
  (let* ((variables (send dob :active-variables '(all)))
         (types (send dob :active-types '(all)))
         (plot)
         (plots-list)
         (plots-lol )
         )
    (dotimes (i (length variables))
             (dotimes (j (length variables))
                      (cond
                        ((= i j)
                         (setf plot (if (equal (select types i) "Numeric")
                                        `(cumulative-plot ,(select variables i) 
                                                          :content-only t)
                                        `(histogram-plot  ,(select variables i) 
                                                          :content-only t))))
                        (t
                         (setf plot (cond 
                                      ((and (equal (select types i) "Numeric")     
                                            (equal (select types j) "Numeric"))
                                       `(scatter-plot (list ,(select variables i) 
                                                            ,(select variables j)) 
                                                      :content-only t))
                                      ((and (equal (select types i) "Category")    
                                            (equal (select types j) "Category"))
                                       `(mosaic-plot  (list ,(select variables i) 
                                                            ,(select variables j)) 
                                                      :content-only t))
                                      ((and (equal (select types i) "Numeric")     
                                            (equal (select types j) "Category"))
                                       `(histogram-plot  ,(select variables i) 
                                                          :content-only t))
                                      ((and (equal (select types i) "Category")     
                                            (equal (select types j) "Numeric"))
                                       `(histogram-plot  ,(select variables i) 
                                                          :content-only t))
                                      ))))
                      (setf plots-list (append plots-list (list plot))))
             (setf plots-lol (append plots-lol (list plots-list)))
             (setf plots-list nil))
    (eval `(view ,plots-lol :style 0))
    ))